USE [PracticeManagement]

DECLARE @SQLString   NVARCHAR(MAX)
        , @SQLVersion  NVARCHAR(10)
        , @TableName   NVARCHAR(MAX)
        , @ReturnValue INT

  PRINT ''
  PRINT 'Index Rebuilt starting at: ' + CONVERT(NVARCHAR, GETDATE(), 113)

  -- Get current SQL compatibility level as commands differ for each version

  SELECT @SQLVersion = cmptlevel
  FROM   master..sysdatabases
  WHERE  name = DB_NAME()

  -- Declare a READ-ONLY cursor to go through each table in Database

  DECLARE CurDatabaseTables CURSOR FOR
          SELECT TABLE_NAME = TABLE_SCHEMA + '.' + TABLE_NAME
          FROM   INFORMATION_SCHEMA.TABLES
          WHERE  TABLE_TYPE   = 'BASE TABLE'   -- User Tables
--          AND    TABLE_SCHEMA = 'dbo'          -- dbo schema
          ORDER BY TABLE_NAME
          FOR READ ONLY

  OPEN CurDatabaseTables

  FETCH NEXT FROM CurDatabaseTables INTO @TableName

  WHILE @@fetch_status = 0
  BEGIN


    BEGIN
      SELECT @SQLString = 'DBCC DBREINDEX(''' + @TableName + ''','''', 90)'
    END

    RAISERROR('Rebuilding Indexes on : %s', 1, 1, @TableName)
 
    EXECUTE @ReturnValue = sp_executesql @SQLString

    IF @ReturnValue <> 0
    BEGIN
      RAISERROR('There is a problem Rebuilding Index on: %s', 1, 1, @TableName)
    END

    RAISERROR ('Finished rebuilding Indexes on %s', 1, 1, @TableName)

    FETCH NEXT FROM CurDatabaseTables INTO @TableName
  END

  CLOSE CurDatabaseTables
  DEALLOCATE CurDatabaseTables

  PRINT 'Index Rebuild Complete at: ' + CONVERT(NVARCHAR, GETDATE(), 113)